require( "HiddenObject/script/style.lua" );


MyFont = {
  standardFont,
  26,
  WhiteColor
};

NameFont = {
  standardFont,
  20,
  WhiteColor
};


FooterGraphics = {
	"HiddenObject/UI/Button/footerbuttonup",
	"HiddenObject/UI/Button/footerbuttondown",
	"HiddenObject/UI/Button/footerbuttonrollover",
};	

FooterStyle= {
	type = kPush,
	flags = kHAlignCenter + kVAlignCenter,
	graphics = FooterGraphics,
	sound = kDefaultButtonSound,
	rolloversound = kDefaultButtonOverSound,
};

local playername = gEnterNameValue;
local deleteselected = gTitleName == "entername";

if not playername or playername=="" then
	deleteselected = true;
	playername = GetString("enternameprompt") ;
end



function GetWindowX()

	x = kCenter;
	if IsMainMenu() then x = 342; end
	return x;
end



function GetWindowY()

	y = kCenter - 45;
	if IsMainMenu() then y = 160; end
	return y;
end

MakeDialog
{
	Bitmap
	{
		image="HiddenObject/UI/Background/smalldialog",
		x=GetWindowX(),
		y=GetWindowY(),
		
		
		Text
		{
			font = MyFont,
			name = "entername",
			x=0,y=25,w=kMax,h=30,
			flags = kHAlignCenter + kVAlignTop,
			label = gTitleName;
			font = StandardHeaderFont,
			h = 40,
		};


		Bitmap
		{
			image="HiddenObject/UI/Background/textfield",
			x=kCenter,
			y=kCenter,

			TextEdit
			{
				font = NameFont,
				name = "nameedit",
				label = playername,
				enablewindow = "enterok",
				clearinitial = deleteselected,
				x=3,y=5,w=kMax-3,h=kMax,
				length=12,
				ignore = kIllegalNameChars

			};
		};

		SetStyle(FooterStyle);	
		Button
		{
			x=kCenter - 80,
			y=-80,
			font = StandardButtonFont,
			graphics = FooterGraphics,
			name="enterok",
			label="ok",
			type = kPush,
			default=true,	-- Make this the default button
			command =
				function()
					local newname = GetLabel("nameedit");
				
					newname = GetLowerCase(newname);
					playername = GetLowerCase(playername);
					local myYesNoBody = "nameinuse";
					local myYesNoTitle = "";
					
					if newname == "" then
						myYesNoBody = "invalidname";
						myYesNoTitle = "invalidnametitle";
					end
					
					if (IsNameInUse(newname, GetCurrentSelectedUser(), deleteselected)) then
						DisplayDialog {
							"HiddenObject/script/ok.lua",
							body = myYesNoBody,
							title = myYesNoTitle
						};
						SetFocus( "nameedit" )
					else 
						if (IsNameInvalid(newname))then
							DisplayDialog 
							{
								"HiddenObject/script/ok.lua",
								body ="invalidname",
								title = "invalidnametitle"
							};
							SetFocus( "nameedit" )
						else
							CloseWindow(GetLabel("nameedit"));
						end
					end
				end
		},

		Button
		{
			x=kCenter + 80,
			y=-80,
			font = StandardButtonFont,
			graphics = FooterGraphics,
			name="entercancel",
			label="cancel",
			type = kPush,
			command =
				function()
					CloseWindow(nil);
				end
		};
	},

}

SetFocus( "nameedit" );

if (deleteselected) then
	EnableWindow("enterok", false);
end


